#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll x, h, idx;
} Jarbol;

int cmp(const void *a, const void *b){
    Jarbol *p1 = (Jarbol*)a;
    Jarbol *p2 = (Jarbol*)b;
    if(p1->x != p2->x) return p1->x < p2->x ? -1 : 1;
    return 0;
}

ll max(ll a, ll b){ return a>b?a:b; }
ll absll(ll a){ return a>=0?a:-a; }

int main(){
    int n;
    scanf("%d",&n);
    Jarbol *arr = malloc(n*sizeof(Jarbol));
    for(int i=0;i<n;i++){ scanf("%lld",&arr[i].x); arr[i].idx=i; }
    for(int i=0;i<n;i++) scanf("%lld",&arr[i].h);

    qsort(arr,n,sizeof(Jarbol),cmp);

    ll *res = malloc(n*sizeof(ll));
    for(int i=0;i<n;i++) res[i]=-1;

    for(int i=0;i<n-1;i++){
        ll x1=arr[i].x,h1=arr[i].h;
        ll x2=arr[i+1].x,h2=arr[i+1].h;
        ll dx = x2 - x1;
        ll dh = h2 - h1;
        ll x_peak = x1 + (dx + h1 - h2)/2;
        ll h_peak = max(h1,h2) + (dx - abs(dh))/2;

        if(arr[i].h <= h1){
            ll d = 0;
            if(res[arr[i].idx]==-1 || d<res[arr[i].idx]) res[arr[i].idx]=d;
        }
        if(arr[i].h <= h_peak){
            ll d = absll(arr[i].x - x_peak);
            if(res[arr[i].idx]==-1 || d<res[arr[i].idx]) res[arr[i].idx]=d;
        }
        if(arr[i].h <= h2){
            ll d = x2 - arr[i].x;
            if(res[arr[i].idx]==-1 || d<res[arr[i].idx]) res[arr[i].idx]=d;
        }

        if(arr[i+1].h <= h2){
            ll d = 0;
            if(res[arr[i+1].idx]==-1 || d<res[arr[i+1].idx]) res[arr[i+1].idx]=d;
        }
        if(arr[i+1].h <= h_peak){
            ll d = absll(arr[i+1].x - x_peak);
            if(res[arr[i+1].idx]==-1 || d<res[arr[i+1].idx]) res[arr[i+1].idx]=d;
        }
        if(arr[i+1].h <= h1){
            ll d = arr[i+1].x - x1;
            if(res[arr[i+1].idx]==-1 || d<res[arr[i+1].idx]) res[arr[i+1].idx]=d;
        }
    }

    for(int i=0;i<n;i++){
        printf("%lld\n",res[i]);
    }

    free(arr);
    free(res);
    return 0;
}